'use client';
import { useLocale } from 'next-intl';

export default function TopBar() {
  const locale = useLocale();
  const date = new Date();
  const year = date.getFullYear();

  return (
    <>
      <div className='flex felx-col w-full justify-center items-center h-fit md:h-[84] bg-main-blue'>
        <div className='container flex w-full h-full flex-col md:flex-row justify-between py-2'>
          <div className='flex w-full md:w-fit p-1.5 flex-row justify-center md:justify-start gap-4 items-center'>
            <bdi className='flex felx-row gap-2 w-fit text-white text-[12px] font-main'>
              {
                locale == "ar" ? `جميع الحقوق محفوظة لشركة السلام للمقاولات © ${year}` : `All rights reserved to Al-Salam Contracting Company © ${year}.`
              }
            </bdi>
          </div>
          <bdi className='flex w-full md:w-fit justify-center md:justify-end items-center'>
            <a href={"https://sabelhost.com"} target='_blank' title='created by: sabelhost for hosting and development' className='flex w-fit text-white text-[12px] font-main cursor-pointer'>
              by: Sabel host for hosting & development
            </a>
          </bdi>
        </div>
      </div>
    </>
  );
}