'use client';

import Image from "next/image";
import { useLocale, useTranslations } from 'next-intl';
import { Link } from '@/i18n/routing';


export default function FooterMain() {
  const locale = useLocale();
  const t = useTranslations('Footer'); 
  const navbarMenu = useTranslations('Navbar');

  return (
    <div className='flex flex-col w-full justify-center items-center h-fit md:h-[389] bg-gray-100 shadow-sm relative z-50'>
      <div className='container flex w-full h-full divide-y divide-gray-300 md:divide-y-0  flex-col md:flex-row justify-between items-center md:py-10 px-4 gap-3'>
        
        <div className='flex-3 w-full justify-start flex-col gap-10  py-4 md:py-0'>
          <Link href={"/"} locale={locale} className="flex">
            <Image 
              src="/assets/logos/logo.svg" 
              alt='Logo' 
              width={198.43} 
              height={131} 
              priority
            />
          </Link>
          <div className="h-5" />
          <div className="flex text-gray-600 text-base font-light font-almarai">
            {t("slogin")}
          </div>
        </div>

        <div className='flex-2 flex justify-start w-full h-full flex-col items-center gap-4  py-4 md:py-0'>
          <div className="w-full flex text-lg font-medium font-main text-blue-800">{t('QuickLinks')}</div>
          <Link href={'/our-projects'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('ourProjects')}</Link>
          <Link href={'/news'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('news')}</Link>
          <Link href={'/digital-gallery'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('digitalGallery')}</Link>
          <Link href={'/careers'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('Careers')}</Link>
          <Link href={'/ongoing-projects'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('ongoingProjects')}</Link>
        </div>
        <div className='flex-2 flex justify-start w-full h-full flex-col items-center gap-4  py-4 md:py-0'>
          <div className="w-full flex text-lg font-medium font-main text-blue-800">{t('Company')}</div>
          <Link href={'/our-projects'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('services')}</Link>
          <Link href={'/factory'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('factory')}</Link>
          <Link href={'/equipment'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('equipment')}</Link>
          <Link href={'/certificates'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('certificates')}</Link>
          <Link href={'/clients'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('clients')}</Link>
          <Link href={'/downloads'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('downloads')}</Link>
        </div>
        <div className='flex-2 flex justify-start w-full h-full flex-col items-center gap-4  py-4 md:py-0'>
          <div className="w-full flex text-lg font-medium font-main text-blue-800">{navbarMenu('contactUs')}</div>
          <Link href={'/contact-us'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('contactUs')}</Link>
          <Link href={'/request-quote'} locale={locale} className="flex w-full justify-start items-center text-sm font-almarai text-gray-600">{navbarMenu('requestQuote')}</Link>
          <br />
          <div className="w-full flex text-lg font-medium font-main text-blue-800">{t('FollowUsOnSocialMedia')}</div>
        </div>
      </div>
    </div>
  );
}