'use client';
import { useTranslations } from 'next-intl';
import { useLocale } from 'next-intl';
import { Link, usePathname } from '@/i18n/routing';

export default function TopBar() {
  const t = useTranslations('Header'); 
  const locale = useLocale();
  const pathname = usePathname();


  return (
    <>
        <div className='flex felx-col w-full justify-center items-center h-[50] bg-main-blue'>
          <div className='container flex w-full h-full felx-row justify-between p-2'>
            <div className='flex p-1.5 flex-row justify-start gap-4'>
              <a href='tel://+202987654321' className='flex felx-row gap-2 w-fit'>
                <svg className='h-5 w-5' viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><g clipPath="url(#clip0_14156_5257)"><path d="M19.1669 9.16667C18.9459 9.16667 18.7339 9.07887 18.5777 8.92259C18.4214 8.76631 18.3336 8.55435 18.3336 8.33334C18.3318 6.56577 17.6289 4.8711 16.379 3.62124C15.1291 2.37138 13.4345 1.66843 11.6669 1.66667C11.4459 1.66667 11.2339 1.57887 11.0777 1.42259C10.9214 1.26631 10.8336 1.05435 10.8336 0.833335C10.8336 0.612321 10.9214 0.40036 11.0777 0.244079C11.2339 0.0877989 11.4459 1.54425e-06 11.6669 1.54425e-06C13.8763 0.00242788 15.9945 0.881181 17.5568 2.44346C19.1191 4.00574 19.9978 6.12394 20.0002 8.33334C20.0002 8.55435 19.9124 8.76631 19.7562 8.92259C19.5999 9.07887 19.3879 9.16667 19.1669 9.16667ZM16.6669 8.33334C16.6669 7.00725 16.1401 5.73548 15.2024 4.7978C14.2648 3.86012 12.993 3.33334 11.6669 3.33334C11.4459 3.33334 11.2339 3.42113 11.0777 3.57741C10.9214 3.73369 10.8336 3.94565 10.8336 4.16667C10.8336 4.38768 10.9214 4.59964 11.0777 4.75592C11.2339 4.9122 11.4459 5 11.6669 5C12.551 5 13.3988 5.35119 14.0239 5.97631C14.6491 6.60143 15.0002 7.44928 15.0002 8.33334C15.0002 8.55435 15.088 8.76631 15.2443 8.92259C15.4006 9.07887 15.6126 9.16667 15.8336 9.16667C16.0546 9.16667 16.2666 9.07887 16.4228 8.92259C16.5791 8.76631 16.6669 8.55435 16.6669 8.33334ZM18.4861 18.47L19.2444 17.5958C19.7271 17.1116 19.9981 16.4558 19.9981 15.7721C19.9981 15.0884 19.7271 14.4326 19.2444 13.9483C19.2186 13.9225 17.2136 12.38 17.2136 12.38C16.7324 11.9219 16.0932 11.6669 15.4288 11.6678C14.7645 11.6687 14.126 11.9256 13.6461 12.385L12.0577 13.7233C10.7612 13.1867 9.58348 12.3993 8.59215 11.4063C7.60082 10.4132 6.81543 9.23411 6.28108 7.93667L7.61441 6.35334C8.07417 5.87348 8.33133 5.2349 8.33241 4.57034C8.3335 3.90578 8.07844 3.26636 7.62025 2.785C7.62025 2.785 6.07608 0.782502 6.05025 0.756668C5.57479 0.278125 4.93015 0.00585322 4.2556 -0.00131947C3.58106 -0.00849216 2.93077 0.25001 2.44525 0.718335L1.48691 1.55167C-4.17475 8.12 8.01691 20.2175 14.8019 20C15.4871 20.004 16.1661 19.8706 16.7988 19.6079C17.4316 19.3451 18.0053 18.9582 18.4861 18.47Z" fill="white"/></g><defs><clipPath id="clip0_14156_5257"><rect width="20" height="20" fill="white"/></clipPath></defs></svg>
                <bdi className='text-white hidden md:flex items-start self-start text-sm font-main'>+202 987 654 321</bdi>
              </a>
              <a href='mailto:info@elsalam.net?subject=استفسار بخصوص الخدمات&body=السلام عليكم، أرغب في الاستفسار عن...' className='flex felx-row gap-2 w-fit'>
                <svg className='h-5 w-5' viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"> <g clipPath="url(#clip0_14156_5254)"> <path d="M19.9617 4.61816L12.9467 11.6332C12.1645 12.4134 11.1048 12.8515 10 12.8515C8.89521 12.8515 7.83552 12.4134 7.05333 11.6332L0.0383333 4.61816C0.0266667 4.74983 0 4.869 0 4.99983V14.9998C0.00132321 16.1045 0.440735 17.1635 1.22185 17.9446C2.00296 18.7258 3.062 19.1652 4.16667 19.1665H15.8333C16.938 19.1652 17.997 18.7258 18.7782 17.9446C19.5593 17.1635 19.9987 16.1045 20 14.9998V4.99983C20 4.869 19.9733 4.74983 19.9617 4.61816Z" fill="white"/> <path d="M11.7675 10.4552L19.3791 2.84266C19.0104 2.23126 18.4903 1.72519 17.8691 1.37327C17.2479 1.02135 16.5465 0.835447 15.8325 0.833496H4.16581C3.45183 0.835447 2.75039 1.02135 2.12916 1.37327C1.50793 1.72519 0.987873 2.23126 0.619141 2.84266L8.23081 10.4552C8.70045 10.9229 9.33629 11.1856 9.99914 11.1856C10.662 11.1856 11.2978 10.9229 11.7675 10.4552Z" fill="white"/> </g> <defs> <clipPath id="clip0_14156_5254"> <rect width="20" height="20" fill="white"/> </clipPath> </defs> </svg>
                <bdi className='text-white hidden md:flex items-start self-start text-sm font-main'>info@elsalam.net</bdi>
              </a>
            </div>
            <div className='flex w-fit p-1.5 bg-light-blue rounded-lg flex-row justify-end gap-4'>
              <Link href={pathname} locale={locale=="ar"?"en":"ar"} className='flex w-fit text-white text-sm font-main cursor-pointer'>
                {t('language')} | {locale=="ar"?"EN":"AR"}
              </Link>
            </div>
          </div>
        </div>
    </>
  );
}