'use client';

import Head from 'next/head';
import { motion, Transition } from "motion/react"

interface PageHeaderItem {
  title: string | "";
  description: string | "";
}

export default function PageHeader(props: PageHeaderItem) {
  const { title, description } = props;

 
  const springTransition: Transition = {
    duration: 0.6,
    delay: 0.3,
    ease: [0, 0.71, 0.2, 1.01],
  };

 
  const descriptionTransition: Transition = {
    ...springTransition,
    delay: 0.4,
  };

  return (
    <>
      <Head>
        <title> {title} | شركة السلام للمقاولات</title>
        <meta name="description" content={description} />
      </Head>
      <div className='h-93.25 w-full flex flex-col justify-start items-center gap-0'>
        <div className='flex w-full p-14 flex-col justify-start items-center bg-no-repeat h-full bg-cover bg-top bg-[url(/assets/images/pagePattern.svg)]'>
          <div className='container flex flex-col gap-8'>
            
            <motion.h1 
              className='text-white font-bold font-main text-[25px] md:text-[40px] line-clamp-2'
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }} 
            >
              {title}
            </motion.h1>

            <motion.div 
              className='text-white font-light font-main text-[16px] line-clamp-4' 
              dangerouslySetInnerHTML={{ __html: description }}
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
            />
            
          </div>
        </div>
        <div className='flex w-full h-12 bg-no-repeat bg-cover bg-top bg-[url(/assets/images/bottomPattern.svg)]' />
      </div>
    </>
  )
}