import {getRequestConfig} from 'next-intl/server';
import {routing} from './routing';

 
export default getRequestConfig(async ({requestLocale}) => {
  let locale = await requestLocale;
 
  if (!locale || !routing.locales.includes(locale as any)) {
    locale = routing.defaultLocale;
  }
  console.log(routing.defaultLocale,locale, requestLocale);
  
 
  return {
    locale,
    messages: (await import(`../messages/${locale}.json`)).default
  };
  
});